# a bit festive 
$ui = $host.UI.RawUI
#[int]$seed = [DateTime]::Now.Millisecond
#$random = new-object Random -argumentList $seed
$random = new-object Random

$winpos = $ui.WindowPosition
$winsize = $ui.WindowSize
$flakecell = $host.ui.rawui.NewBufferCellArray(@("*"),"white",$ui.backgroundcolor)
$numflakes = $winsize.width / 4
$flakes = @()

function new-flake ($x,$y) {
  $rect = new-object Management.Automation.Host.Rectangle($x,$y,$x,$y)
  return @{
    "x" = [int]$x
    "y" = [int]$y
    "oldcoord" = $null
    "oldcells" = $null
  }
}

function draw-flake($flake) {
  # restore previous 
  if ($flake.oldcoord) {
    $ui.SetBufferContents($flake.oldcoord,$flake.oldcells)
  }
  $flake.y++
  if ($flake.y -ge ($winpos.y + $winsize.height)) { 
    $flake.y = $winpos.y
    $flake.x = $winpos.X + $random.Next($winsize.Width)
  }
  # cache prev cell
  $flake.oldcoord = new-object Management.Automation.Host.Coordinates($flake.x,$flake.y)
  $rect = new-object Management.Automation.Host.Rectangle($flake.x,$flake.y,$flake.x,$flake.y)
  $flake.oldcells = $ui.GetBufferContents($rect)
  # draw flake
  $ui.SetBufferContents($flake.oldcoord,$flakecell)
}

$t = $winpos.y + $winsize.height
for ($y = $winpos.y; $y -lt $t; $y += 2) { 
  $x = $winpos.X + $random.Next($winsize.Width)
  $flake = new-flake -x $x -y $y
  $flakes += $flake
}

while ($true) {
  $flakes | foreach { draw-flake $_ }
  sleep -m 20
}